# 画面設計書 12-Simple Browser 2 (Callback)

## 概要

本ドキュメントは、VBCorLibのファイルシステム操作機能とコールバック関数によるソート機能をデモンストレーションするSimple Browser 2画面の設計書である。

### 本画面の処理概要

この画面は、Windowsファイルシステムを階層的に閲覧するためのブラウザアプリケーションである。左側のTreeViewにドライブとディレクトリの階層構造を表示し、右側のListViewに選択ディレクトリ内のファイル一覧を表示する。ファイル一覧のソート機能では、CorArray.Sortにコールバック関数（AddressOf）を渡す方式を採用している。

**業務上の目的・背景**：VBCorLibが提供するDirectoryInfo、FileInfo、DriveInfo等のファイルシステム操作クラスの使用方法をVB6開発者に紹介することを目的としている。また、IComparerインターフェースを実装したクラスの代わりにコールバック関数を使用するソート方式のデモンストレーションも行っている。これは.NET FrameworkのSystem.IO名前空間に相当する機能群である。

**画面へのアクセス方法**：SimpleBrowser2.vbpプロジェクトをVB6 IDEで開き、実行（F5）することでフォームが起動する。スタートアップフォームとしてForm1が設定されている。

**主要な操作・処理内容**：
1. フォーム起動時にEnvironment.GetLogicalDrivesで全ドライブを取得し、TreeViewに表示
2. TreeViewでドライブまたはディレクトリをクリックすると、サブディレクトリを展開
3. 選択ディレクトリ内のファイル一覧をListViewに表示（ファイル名、サイズ、更新日時）
4. ListViewのカラムヘッダークリックでソート列・ソート順を変更
5. コールバック関数（FileInfoComparer）でファイル配列をソート

**画面遷移**：本画面は独立したデモアプリケーションであり、他の画面への遷移は存在しない。

**権限による表示制御**：特になし。ローカルファイルシステムへの読み取りアクセス権限が必要。アクセス不可のドライブ選択時はエラーメッセージを表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | DirectoryInfo | 主機能 | ディレクトリ情報の取得（GetDirectories） |
| 36 | FileInfo | 主機能 | ファイル情報の取得（GetFiles、Name、Length、LastAccessTime） |
| 38 | DriveInfo | 補助機能 | ドライブ準備状態の確認（IsReady、Name） |
| 8 | Environment | 補助機能 | 論理ドライブ一覧の取得（GetLogicalDrives） |
| 1 | CorArray | 補助機能 | ファイル配列のソート（Sort with callback） |
| 2 | CorString | 補助機能 | 文字列フォーマット処理（Format） |
| 14 | CorMath | 補助機能 | ファイルサイズの切り上げ計算（Ceiling） |

## 画面種別

一覧（エクスプローラー形式、マスター・ディテール）

## URL/ルーティング

該当なし（VB6デスクトップアプリケーション）

## 入出力項目

### 入力項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|----------|------|------|
| ドライブ/ディレクトリ選択 | Node | Yes | TreeViewでユーザーが選択したノード |
| ソート列選択 | ColumnHeader | No | ListViewでクリックされたカラムヘッダー |

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ドライブ一覧 | String配列 | システム上の全論理ドライブ |
| サブディレクトリ一覧 | DirectoryInfo配列 | 選択ディレクトリ直下のサブディレクトリ |
| ファイル一覧 | FileInfo配列 | 選択ディレクトリ内の全ファイル |

## 表示項目

### ディレクトリツリー（TreeView1）

| 項目名 | 説明 |
|--------|------|
| ドライブ | システム上の論理ドライブ（C:\, D:\ 等） |
| フォルダ | ディレクトリ階層（展開時にサブディレクトリを動的ロード） |

### ファイルリスト（ListView1）

| 列名 | 幅 | 整列 | 説明 |
|------|-----|------|------|
| Name | 2500 twips | 左 | ファイル名 |
| Size | デフォルト | 右 | ファイルサイズ（KB単位、カンマ区切り） |
| Date Modified | 2500 twips | 左 | 最終アクセス日時 |

## イベント仕様

### 1-Form_Load

フォーム初期化時に実行される。

**処理フロー**：
1. ListView1にカラムヘッダーを追加（Name、Size、Date Modified）
2. ShowDrives関数でドライブ一覧をTreeViewに表示
3. 最初のドライブノードを選択状態に設定
4. ShowSubDirectories関数で最初のドライブの内容を表示

### 2-TreeView1_Click

TreeViewでノードクリック時に実行される。

**処理フロー**：
1. 選択されたノード（TreeView1.SelectedItem）を取得
2. ShowSubDirectories関数を呼び出し

### 3-ListView1_ColumnClick

ListViewのカラムヘッダークリック時に実行される。

**処理フロー**：
1. クリックされた列が現在のソート列と同じ場合、ソート順を反転（Ascending/Descending）
2. 異なる列の場合、新しいソート列を設定
3. ShowSubDirectories関数を呼び出してファイル一覧を再表示

### 4-ShowSubDirectories（Private Sub）

選択ノードのサブディレクトリを展開し、ファイル一覧を表示する。

**処理フロー**：
1. NewDirectoryInfoでノードのフルパスからDirectoryInfoを生成
2. NewDriveInfoでドライブ情報を取得し、IsReadyをチェック
3. ドライブ未準備の場合はエラーメッセージを表示して終了
4. ノードに子がない場合、GetDirectoriesでサブディレクトリを取得
5. 各サブディレクトリをTreeViewに追加
6. ShowFiles関数でファイル一覧を表示

### 5-ShowFiles（Private Sub）

指定ディレクトリ内のファイル一覧を表示する。

**処理フロー**：
1. DirectoryInfo.GetFilesでファイル配列を取得
2. CorArray.SortでAddressOf FileInfoComparerを指定してソート
3. ListView1をクリア
4. 各ファイルをListView1に追加（Name、Size、LastAccessTime）
5. サイズはCeiling関数で1000で割ってKB単位に変換、N0書式でカンマ区切り

### 6-ShowDrives（Private Sub）

システム上の全ドライブをTreeViewに表示する。

**処理フロー**：
1. Environment.GetLogicalDrivesでドライブ一覧を取得
2. 各ドライブをTreeView1.Nodesに追加
3. 最初のノードを選択状態に設定

### 7-FileInfoComparer（Module1.bas - コールバック関数）

CorArray.Sortから呼び出されるコールバック比較関数。

**処理フロー**：
1. SortColumn（Name/Size/Modified）に応じて比較方法を選択
2. Name: CorString.CompareでOrdinalIgnoreCase比較
3. Size: Sgn関数でファイルサイズ差の符号を取得
4. Modified: cDateTime.CompareToで日時比較
5. SortOrder=Descendingの場合、結果を符号反転

## データベース更新仕様

該当なし（ファイルシステムの読み取りのみ）

## メッセージ仕様

| 種別 | 条件 | メッセージ内容 |
|------|------|---------------|
| エラー | ドライブ未準備 | "Drive '{ドライブ名}' is not ready." |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| ドライブ未準備（IsReady=False） | MsgBoxでエラー表示、処理を中断 |
| ディレクトリアクセスエラー | VBのデフォルトエラー処理に委譲 |

## 備考

- MSCOMCTL.OCX（TreeView、ListView等のコモンコントロール）が必要
- VBCorLib 3.0ライブラリ（vbcorlib3.dll）への参照設定が必要
- コールバック関数はModule1.basに定義（クラスモジュールではAddressOf使用不可のため）
- ImageList1にフォルダアイコン（Closed、Open）が定義されている
- Simple Browser（No.14）との違いはソート方式（コールバック vs IComparer）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ファイルシステム情報を表現するVBCorLibのクラス構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Module1.bas | `Examples/IO Examples/SimpleBrowser2/Module1.bas` | SortDirection列挙型、SortColumn/SortOrder変数、FileInfoComparerコールバック関数の構造を理解する |

**読解のコツ**: コールバック関数はPublicで宣言し、引数はByRefで受け取る必要がある。戻り値は負（x<y）、0（x=y）、正（x>y）の3パターン。

#### Step 2: エントリーポイントを理解する

処理の起点となるフォームのイベントハンドラを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Form1.frm | `Examples/IO Examples/SimpleBrowser2/Form1.frm` | フォームの初期化処理とユーザー操作によるイベント処理の流れを理解する |

**主要処理フロー**:
1. **行188-198（Form_Load）**: フォーム初期化。ListView設定、ドライブ表示、初期ディレクトリ表示
2. **行224-226（TreeView1_Click）**: ディレクトリ選択時の処理
3. **行203-219（ListView1_ColumnClick）**: ソート列/順の変更
4. **行86-123（ShowSubDirectories）**: サブディレクトリ展開とファイル一覧表示
5. **行128-167（ShowFiles）**: ファイル一覧の取得・ソート・表示
6. **行172-183（ShowDrives）**: ドライブ一覧表示

#### Step 3: コールバック関数の理解

CorArray.Sortに渡されるコールバック関数の動作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Module1.bas | `Examples/IO Examples/SimpleBrowser2/Module1.bas` | FileInfoComparer関数の実装。3つのソート列（Name、Size、Modified）への対応方法 |

**主要処理フロー**:
- **行36-58（FileInfoComparer）**: コールバック関数本体
- **行43-44**: Name列のソート（CorString.CompareでOrdinalIgnoreCase）
- **行46-47**: Size列のソート（Sgn関数）
- **行49-50**: Modified列のソート（CompareToメソッド）
- **行57**: Descendingの場合の符号反転

### プログラム呼び出し階層図

```
Form1.frm
    │
    ├─ Form_Load (行188)
    │      ├─ ListView1.ColumnHeaders.Add (カラム設定)
    │      ├─ ShowDrives (行172)
    │      │      └─ Environment.GetLogicalDrives (VBCorLib)
    │      └─ ShowSubDirectories (行86)
    │             ├─ NewDirectoryInfo (VBCorLib)
    │             ├─ NewDriveInfo (VBCorLib)
    │             │      └─ DriveInfo.IsReady
    │             ├─ DirectoryInfo.GetDirectories
    │             └─ ShowFiles (行128)
    │                    ├─ DirectoryInfo.GetFiles
    │                    ├─ CorArray.Sort (VBCorLib)
    │                    │      └─ Module1.FileInfoComparer (行36)
    │                    │             ├─ CorString.Compare
    │                    │             ├─ Sgn(Length)
    │                    │             └─ cDateTime.CompareTo
    │                    └─ ListView1.ListItems.Add
    │
    ├─ TreeView1_Click (行224)
    │      └─ ShowSubDirectories (再帰的)
    │
    └─ ListView1_ColumnClick (行203)
           ├─ SortColumn/SortOrder更新 (Module1)
           └─ ShowSubDirectories
```

### データフロー図

```
[入力]                    [処理]                         [出力]

起動時 ─────────────────▶ GetLogicalDrives ──────────▶ ドライブ一覧
                         (行175)                       (TreeView1)
                              │
TreeView選択 ───────────▶ NewDirectoryInfo ──────────▶ DirectoryInfo
(ノードクリック)          (行94)                        (Dir)
                              │
                              ▼
                         GetDirectories ─────────────▶ サブディレクトリ
                         (行109)                       (TreeView1に追加)
                              │
                              ▼
                         GetFiles ───────────────────▶ FileInfo配列
                         (行131)                       (Files)
                              │
                              ▼
                         CorArray.Sort ──────────────▶ ソート済み配列
                         (行135)
                              │
                              ▼
                         ListView表示 ───────────────▶ ファイル一覧
                         (行139-166)                   (名前/サイズ/日時)

カラムクリック ─────────▶ SortColumn/Order更新 ──────▶ 再ソート・再表示
(ListView1)               (行208-214)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Form1.frm | `Examples/IO Examples/SimpleBrowser2/Form1.frm` | ソース | メインフォーム。UI、イベント処理、ファイルシステム操作 |
| Form1.frx | `Examples/IO Examples/SimpleBrowser2/Form1.frx` | バイナリ | ImageListのアイコンデータ |
| Module1.bas | `Examples/IO Examples/SimpleBrowser2/Module1.bas` | ソース | ソート用コールバック関数とソート設定変数 |
| SimpleBrowser2.vbp | `Examples/IO Examples/SimpleBrowser2/SimpleBrowser2.vbp` | プロジェクト | VBプロジェクトファイル |
| vbcorlib3.dll | `Binaries/Compiled/vbcorlib3.dll` | ライブラリ | VBCorLibランタイム |
| MSCOMCTL.OCX | System32 | OCX | TreeView/ListViewコントロール |
